from ctypes import *
from numpy import linalg,sqrt,dot,zeros,double,real,pi,sin,argsort,real
from pymol import cmd, stored
from pickle import dump

cdll.LoadLibrary('/usr/lib/libgmx_d.so.5')
gmx_mtxio_read = CDLL('/usr/lib/libgmx_d.so.5').gmx_mtxio_read

def loadmtx(mtx):
  nrow = c_int(0)
  ncol = c_int(0)
  hess = POINTER(c_double)()
#  hess = POINTER(c_float)()
  gmx_sparsematrix = POINTER(c_byte)()
  gmx_mtxio_read(mtx, byref(nrow), byref(ncol), byref(hess), byref(gmx_sparsematrix))
  ahess = zeros((nrow.value, ncol.value), dtype=double)
  for i in range(nrow.value):
    for j in range(ncol.value):
      ahess[i,j] = hess[i*ncol.value+j]
  return ahess

def nmgen(obj, nmid, mtx=None, amp=1., nframes=20, dump_file=False):
  """ 
nmgen - generate normal mode from GROMACS .mtx file

Usage: nmgen obj, nmid, [mtx=None, [amp=1.0, [nframes=20]]]

NB: * This script depends on GROMACS libraries. Check for libgmx_d.so.5 in /usr/lib. 
    * The script works with full (double) precision MTX files. 
      Slight modifications to script are needed to work with single precision files.

Example:
  Load structure
  >  load molecule.pdb

  Load appropriate mtx and generate normal mode #3
  >  nmgen molecule, 3, molecule.mtx

  Generate normal mode 7 with magnitude 3.0 A.
  No mtx file is specified since we have already loaded it for this structure.
  >  nmgen molecule, 7, amp=3.0
  """
  nmid = int(nmid)
  amp = float(amp)
  newobj = "%s-nm_%d" % (obj, nmid)
  genwv = 0
  cmd.delete(newobj)

  try:
    stored.NMA[obj]
  except AttributeError:
    stored.NMA = {}
    genwv = 1
  except KeyError:
    genwv = 1

  if genwv or mtx:
    if not mtx:
      print "Please specify gromacs MTX file"
      return 0
    stored.mass = {'H':1., 'C':12.,'N':14.,'O':16.,'M':24.3}
    hess = loadmtx(mtx)
    MI = 0.*hess
    stored.MI = MI
    cmd.iterate_state(1,obj,"stored.MI[(ID-1)*3,(ID-1)*3]=1./stored.mass[elem]")
    for id in range(hess.shape[0]/3):
      MI[id*3+1,id*3+1],MI[id*3+2,id*3+2] = MI[id*3,id*3],MI[id*3,id*3]
    w2,v = linalg.eig(dot(MI, hess))
    w = sqrt(w2)*1.e12
    stored.NMA[obj] = {}
    stored.NMA[obj]['hess'] = hess
    stored.NMA[obj]['w'] = w
    stored.NMA[obj]['v'] = v
    if dump_file: 
      f=open(dump_file, 'w')
      dump((hess,MI,w,v), f)
      f.close()
  else:
    w = stored.NMA[obj]['w']
    v = stored.NMA[obj]['v']

  si=argsort(w)
  print "%7s%20s%20s" % ('NMID', 'f Hz', 'f cm^-1')
  for i in range(w.size):
    print "%7d%20.5e\t%20.0f" % (i, w[si[i]]/2./pi, w[si[i]]*5.30884e-12),
    if i == nmid:
      print "*"
    else:
      print ""
  nm = real(v[:,si[nmid]])
  nm *= amp/sqrt((nm**2).sum())
  for ifr in range(nframes):
    cmd.create(newobj, obj, 1, ifr+1)
    stored.nm = nm*sin(2.*pi*ifr/nframes)
    cmd.alter_state(ifr+1, newobj, "x,y,z = x+stored.nm[(ID-1)*3], y+stored.nm[(ID-1)*3+1], z+stored.nm[(ID-1)*3+2]")
cmd.extend("nmgen", nmgen)

